<?php
/***********************************************************************************
 *
 * Select accounting period ---- Select accounting period module for Joomla v3.9
 *
 * @version   0.0.1
 * @author    Tymoa <tymoa@eus.bzh>
 * @link      https://joomla.eus.bzh
 * @copyright Copyright (C) 2020 Tymoa. All rights reserved.
 * @license   GNU General Public License version 3 or later; See LICENSE.txt.
 * 
 * Select accounting period is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Select accounting period is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Select accounting period. If not, see <https://www.gnu.org/licenses/>.
 *
 **********************************************************************************/

/**
 * @file
 * @brief This file is the helper file to show select accounting period.
 *
 * This file is used to get and manage data for the module.
 *
 * @package    Joomla
 * @subpackage mod_select_accounting_period
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_accounting/models', 'accountingperiod');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_accounting/models', 'accountingperiods');
use Joomla\CMS\Factory;

/**
 * @brief This class is the helper file to retrieve select accounting period data
 */
class modSelect_accounting_periodHelper
{
	/**
	 * Get the data
	 *
	 * @param JObject &$params The module parameters.
	 */
	public static function set(&$params)
	{
		$session = Factory::getSession();

		// Retrieve the session accounting period
		$accountingperiod_id = $session->get('accountingperiod_id');

		if ($accountingperiod_id)
		{
			$params->set('accountingperiod_id', $accountingperiod_id);
		}
		else
		{
			$accountingperiod_id = $params->get('accountingperiod_id', 0);
			$session->set('accountingperiod_id', $accountingperiod_id);
		}

		// Retrieve the entity
		if ($accountingperiod_id)
		{
			$modelAcntPeriod = JModelLegacy::getInstance('Accountingperiod','AccountingModel');
			$accountingperiod = $modelAcntPeriod->getItem($accountingperiod_id);
			$session->set('entity_id', $accountingperiod->entity_id);
		}
		else
			$session->set('entity_id', 0);
	}

	/**
	 * Get the list of all available accounting periods
	 *
	 * @return array An array of accounting periods.
	 */
	public static function getAccountingPeriods($status)
	{
		// Retrieve the entity
		$modelAcntPeriods = JModelLegacy::getInstance('Accountingperiods','AccountingModel');
		$accountingperiods = $modelAcntPeriods->getAccountingperiods(0, $status);

		// Return the result
		return $accountingperiods;
	}
}
