<?php
/***********************************************************************************
 *
 * Select accounting period ---- Select accounting period module for Joomla v3.9
 *
 * @version   0.0.1
 * @author    Tymoa <tymoa@eus.bzh>
 * @link      https://joomla.eus.bzh
 * @copyright Copyright (C) 2020 Tymoa. All rights reserved.
 * @license   GNU General Public License version 3 or later; See LICENSE.txt.
 * 
 * Select accounting period is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Select accounting period is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Select accounting period. If not, see <https://www.gnu.org/licenses/>.
 *
 **********************************************************************************/

/**
 * @file
 * @brief Default layout for the select accounting period.
 *
 * This layout shows data from select accounting period.
 *
 * @package    Joomla
 * @subpackage mod_select_accounting_period
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

//JHtml::_('bootstrap.tooltip');
$one_is_selected = false;
?>
<div class="row-striped">
	<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" id="accounting_form" class="form-inline">
		<div id="form-accountingperiod-id" class="control-group">
			<div class="controls">
				<select name="accountingperiod_id" onChange="accounting_form.submit();">
				<?php foreach($accountingperiods as $accountingperiod) : ?>
				<?php 	$selected = ($accountingperiod->id == $params->get('accountingperiod_id', 0)) ? " selected" : ""; ?>
				<?php 	$one_is_selected = $one_is_selected || ($accountingperiod->id == $params->get('accountingperiod_id', 0)); ?>
				<?php 	echo "<option value='".$accountingperiod->id."'".$selected.">".$accountingperiod->entity." (".$accountingperiod->start_date." => ".$accountingperiod->end_date.")</option>"; ?>
				<?php endforeach; ?>
				<?php if (!$one_is_selected) : ?>
				<?php 	echo "<option value='0' selected>".JText::_('MOD_SELECT_ACCOUNTING_PERIOD_NONE')."</option>"; ?>
				<?php endif; ?>
				</select>
			</div>
		</div>
		<input type="hidden" name="option" value="com_accounting" />
		<input type="hidden" name="task" value="accountingperiod.setSessionParameters" />
	</form>
</div>
